/* eslint-disable no-console */
/* eslint-disable no-plusplus */
/* eslint-disable prefer-destructuring */
/* eslint-disable no-else-return */
/* eslint-disable no-restricted-syntax */
/* eslint-disable guard-for-in */
/* eslint-disable no-undef */
/* eslint-disable no-unused-vars */


class FormAttribute {
	constructor(att, dataclass, settings) {
		this.att = att;
		this.settings = settings;
	}
}


class FormManager {
	constructor(dataclass, sel, curpos, formPlaceHolders, path, level, attributes = null, gridManager = null, errorManager = null) {
		this.dataclass = dataclass;
		this.sel = sel;
		this.curpos = curpos;
		this.curEntity = null;
		this.ds = dataclass.getDataStore();
		this.path = path;
		this.level = level;

		this.errorManager = errorManager;

		this.attsSettings = SettingManager.getProperty('formManager.attributeSettings', this.dataclass);
		if (this.attsSettings == null)
			this.attsSettings = {};

		this.$formContent = formPlaceHolders.$formContent;
		this.$formTitle = formPlaceHolders.$formTitle;
		this.$formFooter = formPlaceHolders.$formFooter;

		if (attributes == null) {
			this.attributes = this.buildAllAttributes(true);
		} else
			this.attributes = attributes;
		
		this.displayedAttsByName = {};
		this.buildForm(this.attributes, path, level);

		this.installToolBar();
		this.grid = gridManager;

		this.queryHandler = null;
		this.allowEdit = false;
	}

	setQueryHandler(queryHandler) {
		this.queryHandler = queryHandler;
	}

	installToolBar() {
		if (this.$formFooter != null) {
			this.$formBar1 = this.$formFooter.find('.formBar1');
			this.$formBar2 = this.$formFooter.find('.formBar2');
			this.$formBar1.find('.formBar1Button').on('click', this.handleNavigateClick.bind(this));
			this.$formBar2.find('.formBar2Button').on('click', this.handleEditClick.bind(this));
			this.$formBar2.find('.editCheck').on('change', this.handleAllowEditClick.bind(this));
			this.$formBar2.find('.toggle-container').on('click', this.handleAllowEditClick.bind(this));
			this.$formBar2.find('.formBar2Clicker').off();
			this.$formBar2.find('.formBar2Clicker').on('mousedown', this.handleMousedown.bind(this));
			this.$formBar2.find('.formBar2Clicker').on('mouseup', this.handleMouseup.bind(this));

			const $editcheck = this.$formBar2.find('.editCheck');
			$editcheck.prop('checked', false);
		}
	}

	handleMousedown(event, ui) {
		if (this.grid != null)
			this.grid.$gridelem.find('.modified').addClass('withHighlight');
	}

	handleMouseup(event, ui) {
		if (this.grid != null)
			this.grid.$gridelem.find('.modified').removeClass('withHighlight');
	}

	handleNavigateClick(event) {
		const buttontype = event.target.classList[0];
		const grid = this.grid;
		if (grid != null) {
			switch (buttontype) {
				case 'first':
					grid.selectFirstRow();
					break;
				case 'last':
					grid.selectLastRow();
					break;
				case 'next':
					grid.selectNextRow();
					break;
				case 'previous':
					grid.selectPreviousRow();
					break;
				default:
					break;
			}
		}
	}

	handleEditClick(event) {
		const buttontype = event.target.parentElement.classList[0];
		switch (buttontype) {
			case 'new':
				{
					const newentity = this.dataclass.newEntity();
					this.fillForm(newentity);
				}
				break;
			
			case 'reload':
				{
					if (this.curEntity != null) {
						if (this.curEntity.isNew()) {
							const newentity = this.dataclass.newEntity();
							this.fillForm(newentity);
						} else {
							this.dataclass.getEntity(this.curEntity.getKey()).then((reloadedentity) => {
								if (this.grid != null) {
									this.grid.hasSavedEntity(this.curEntity);
								}
								this.curEntity = reloadedentity;
								this.fillForm(reloadedentity);
							});
						}
					}
				}
				break;

			case 'save':
				{
					if (this.curEntity != null) {
						if (this.curEntity.isNew()) {
							this.curEntity.save().then(async(savedEntity) => {
								this.curEntity = savedEntity;
								this.fillForm(savedEntity);
								await this.grid.addEntity(this.curEntity);
								
								/*
								const newentity = this.dataclass.newEntity();
								this.fillForm(newentity);
								*/
								
							}).catch(err => {
								if (this.grid != null) {
									this.grid.couldNotSaveEntity(this.curEntity, err);
									if (this.errorManager != null) {
										this.errorManager.display(`Could not save the new entity `, err.message);
									}
								}
							});
						} else if (this.curEntity.touched()) {
							this.curEntity.save().then(savedEntity => {
								if (this.grid != null) {
									this.grid.hasSavedEntity(this.curEntity);
								}
								this.curEntity = savedEntity;
								this.fillForm(savedEntity);
							}).catch(err => {
								if (this.grid != null) {
									this.grid.couldNotSaveEntity(this.curEntity, err);
									if (this.errorManager != null) {
										this.errorManager.display(`Could not save entity with key ${this.curEntity.getKey()} `, err.message);
									}
								}
							});
						}
					}
				}
				break;
			
			case 'delete':
				{
					if (this.grid != null) {
						const sel = this.grid.getSelection();
						const range = this.grid.getSelectedRows();
						if (range.length > 0) {
							const newPosToScroll = range[0];
							const manager = this;
							if (sel != null) {
							
								sel.removeRangeOfEntities(range).then((newsel) => {
									const rangeNotDeleted = newsel.getSelectedRange();
									manager.grid.setCurrentSelection(newsel, newPosToScroll);
									if (rangeNotDeleted != null && rangeNotDeleted.length > 0) {
										if (manager.errorManager != null) {
											manager.errorManager.display(`${rangeNotDeleted.length} ${rangeNotDeleted.length > 1 ? "entities" : "entity"} out of ${range.length} could not be deleted`, "");
										}
									}
								}).catch(err => {
									if (manager.errorManager != null) {
										manager.errorManager.display(`While trying to delete entities: `, err.message);
									}
								});
							}
						}
							
					}
				}
				break;
			
			default:
				break;
		}
	}

	handleAllowEditClick(event) {
		let $editcheck = this.$formBar2.find('.editCheck');
		let ischecked = $editcheck.prop('checked');
		if ($(event.currentTarget).hasClass('toggle-container')) {
			ischecked = !ischecked;
			$editcheck.prop('checked', ischecked);
		}
		this.allowEdit = ischecked;
		this.updateAllowEditStatus();
	}

	saveCurrentEntity() {
		const curentity = this.curEntity;
		if (curentity != null && curentity.touched()) {
			curentity.save().then(savedEntity => {
				if (this.grid != null) {
					this.grid.hasSavedEntity(curentity);
				}
				if (this.curEntity == curentity) {
					this.curEntity = savedEntity;
					this.fillForm(savedEntity);
				}
			}).catch(err => {
				this.grid.couldNotSaveEntity(curentity, err);
			});
		}

	}

	getAttSettings(attName, buildIfMissing = false) {
		let attsetting = this.attsSettings[attName];
		if (attsetting == null && buildIfMissing) {
			attsetting = {};
			this.attsSettings[attName] = attsetting;
		}
		return attsetting;
	}

	saveSettings() {
		SettingManager.setProperty('formManager.attributeSettings', this.attsSettings, this.dataclass);
		SettingManager.setProperty('formManager.attOrder', this.attOrder, this.dataclass);
		this.saveDisplayAttributes();
	}

	saveDisplayAttributes() {
		if (!this.isBuilding) {
			const arr = [];
			this.attributes.forEach((displayAtt) => {
				const obj = {};
				for (let e in displayAtt) {
					if (e[0] !== '$' && e !== 'subgrid' && e !== 'subgridWind' && e !== 'subform' && e !== 'subformWind' && e !== 'att' && e !== 'jsonEditor' && e !== 'subwindPos') {
						obj[e] = displayAtt[e];
					} else {
						if (e === '$subgridWind' || e === '$subformWind') {
							const $dial = displayAtt[e];
							if ($dial != null) {
								if ($dial.dialog('isOpen')) {
									const $parent = $dial.parent();
									const pos = {
										left: parseInt($parent.css('left')),
										top: parseInt($parent.css('top')),
										width: $dial.dialog('option', 'width'),
										height: $dial.dialog('option', 'height'),
									}
									obj.subwindPos = pos;
								}
							}
						}
					}
				}
				obj.attName = displayAtt.att.name;
				arr.push(obj);
			});
			SettingManager.setProperty('formManager.displayAttributes', arr, this.dataclass, this.level === 0 ? null : this.path);
		}
	}


	loadDisplayAttributes() {
		let displayAtts = null;
		const dataclass = this.dataclass;
		const arr = SettingManager.getProperty('formManager.displayAttributes', this.dataclass, this.level === 0 ? null : this.path);
		if (arr != null) {
			displayAtts = [];
			arr.forEach((obj) => {
				const displayAtt = {};
				for (let e in obj) {
					if (e === 'attName') {
						const attName = obj.attName;
						displayAtt.att = dataclass.getAttribute(attName);
					} /* else if (e === 'subwindPos') {
						const pos = obj[e];

					} */ else {
						displayAtt[e] = obj[e];
					}
				}
				displayAtts.push(displayAtt);
			});

		}
		return displayAtts;
	}

	buildAllAttributes(includesRelated = false) {
		const atts = this.dataclass.getAllAttributes();
		let attributes = this.loadDisplayAttributes();
		if (attributes == null)
			attributes = [];
		const attsByName = {};
		this.displayedAttsByName = attsByName;
		Object.values(attributes).forEach((displayAtt) => {
			attsByName[displayAtt.att.name] = displayAtt;
		});

		const manager = this;
		Object.values(atts).forEach((att) => {
			if (attsByName[att.name] == null) {
			const addAtt = { att, label: att.name, width: 300, nextline:true };
			const attSettings = manager.getAttSettings(att.name);

			let canAdd = true;
				if (att.kind === 'relatedEntity' || att.behavior === 'relatedEntity') {
					if (includesRelated) {
						addAtt.format = 'form';
						addAtt.inputFormat = 'form';
						addAtt.height = 500;
						addAtt.width = -1;
					} else {
						canAdd = false;
					}
				} else if (att.kind === 'relatedEntities' || att.behavior === 'relatedEntities') {
					if (includesRelated) {
						addAtt.format = 'grid';
						addAtt.inputFormat = 'grid';
						addAtt.height = 500;
						addAtt.width = -1;
					} else {
						canAdd = false;
					}
				} else {
					addAtt.readOnly = att.readOnly;
					if (att.kind === 'storage' || (att.kind === 'calculated' && att.behavior == null) || att.kind === 'alias') {
						switch (att.type) {
							case 'string':
							case 'text':
								addAtt.format = 'text';
								addAtt.inputFormat = 'text';
								addAtt.width = 300;
								break;

							case 'uuid':
								addAtt.format = 'text';
								addAtt.inputFormat = 'text';
								addAtt.width = 280;
								break;

							case 'number':
								addAtt.format = 'number';
								addAtt.inputFormat = 'text';
								addAtt.width = 120;
								break;

							case 'integer':
							case 'word':
								addAtt.format = 'integer';
								addAtt.inputFormat = 'text';
								addAtt.width = 60;
								break;

							case 'long':
							case 'long64':
								addAtt.format = 'integer';
								addAtt.inputFormat = 'text';
								addAtt.width = 120;
								break;

							case 'duration':
								addAtt.format = 'duration';
								addAtt.inputFormat = 'text';
								addAtt.width = 90;
								break;


							case 'date':
								addAtt.format = 'date';
								addAtt.inputFormat = 'text';
								addAtt.width = 120;
								break;

							case 'bool':
							case 'boolean':
								addAtt.format = 'checkbox';
								addAtt.inputFormat = 'checkbox';
								break;

							case 'object':
								addAtt.format = 'object';
								addAtt.inputFormat = 'object';
								addAtt.width = 400;
								addAtt.height = 300;
								break;

							case 'image':
								addAtt.format = 'image';
								addAtt.inputFormat = 'image';
								addAtt.width = 300;
								addAtt.height = 300;
								addAtt.squarePict = false;
								break;

							case 'blob':
								addAtt.format = 'blob';
								addAtt.inputFormat = 'blob';
								addAtt.width = 100;
								break;

							default:
								if (att.kind === 'alias') {
									addAtt.format = 'text';
									addAtt.inputFormat = 'text';
									addAtt.width = 300;
								}
								break;
						}
					}
				}
				
				if (attSettings != null && attSettings.width != null) {
					addAtt.width = attSettings.width;
				}
				if (attSettings != null && attSettings.height != null) {
					addAtt.height = attSettings.height;
				}
				if (attSettings != null && attSettings.squarePict != null) {
					addAtt.squarePict = attSettings.squarePict;
				}
	
				if (canAdd)
					attributes.push(addAtt);
			}

		});
		return attributes;
	}

	handleShapeButtonClick(event) {
		const $target = $(event.currentTarget);
		const square = $target.hasClass('squareButton');
		const attName = betterDecodeURIComponent(event.currentTarget.getAttribute('data-attribute'));
		if (attName != null) {
			$target.siblings('button').removeClass('shapeButtonSelected');
			$target.addClass('shapeButtonSelected');
			const $image = this.$formContent.find(`.formElem[data-attribute="${encodeURIComponent(attName)}"] .formElemImage`);
			if (square) {
				$image.removeClass('rounded');
				$image.addClass('square');
			} else {
				$image.removeClass('square');
				$image.addClass('rounded');
			}
			const attSettings = this.getAttSettings(attName, true);
			attSettings.squarePict = square;
			const displayAtt = this.displayedAttsByName[attName];
			displayAtt.squarePict = square;
			this.saveSettings();
			if (this.grid != null)
				this.grid.SetPictColumn(attName, square);
		}

	}

	handleSaveWindowsSettings(event, ui) {
		this.saveDisplayAttributes();
	}

	createSubFormDialog($parent, displayAtt, subpath) {
		const manager = this;
		const attName = displayAtt.att.name;
		$parent.append(`<div class="windowForm level${manager.level%5+1}" title="${subpath}" style="width:500px;height:500px;"><div class="windowFormContent subFormContent"></div></div>`);
		const $wind = $parent.find('.windowForm');
		const subwindPos = displayAtt.subwindPos;
		let width = 500;
		let height = 500;
		if (subwindPos != null) {
			width = subwindPos.width;
			height = subwindPos.height;
		}
		$wind.dialog({
			width: width,
			height: height,
			close: this.handleSaveWindowsSettings.bind(this),
			open: this.handleSaveWindowsSettings.bind(this),
			dragStop: this.handleSaveWindowsSettings.bind(this),
			resizeStop: this.handleSaveWindowsSettings.bind(this)
		});

		if (subwindPos != null)
		{
			const $dialparent = $wind.parent();
			$dialparent.css('left', subwindPos.left);
			$dialparent.css('top', subwindPos.top);
		}
		const relDataClass = manager.ds.getDataClass(displayAtt.att.type);
		displayAtt.$subformWind = $wind;
		displayAtt.subformWind = new FormManager(relDataClass, null, 0, { $formContent: $wind.find('.subFormContent') }, subpath, manager.level + 1, null, null, manager.errorManager);
		if (manager.curEntity != null) {
			const value = manager.curEntity[attName];
			if (value != null) {
				value.fetch().then(subentity => {
					displayAtt.subformWind.fillForm(subentity);
				}).catch(err => {
					displayAtt.subformWind.fillForm(null);
					if (manager.errorManager != null) {
						manager.errorManager.display(`Could not get ${manager.path + '.' + attName}`, err.message);
					}
				});
			}
		}
	}

	createSubGridDialog($parent, displayAtt, subpath) {
		const manager = this;
		const attName = displayAtt.att.name;

		let html;
		html = `<div class="windowForm level${manager.level % 5 + 1}" title="${subpath}" style="width:500px;height:500px;">`;
		html += '  <div class="windowFormContent dataGrid"></div>'
		html += '  <div class="rawDisplayFooter">';
		html += '    <span class="rawDisplayFooterLabel">result: </span>';
		html += '    <span class="rawDisplayFooterValue"></span>';
		html += '    <span class="rawDisplayFooterLabel">/</span>';
		html += '    <span class="rawDisplayFooterValue2"></span>';
		html += '  </div>';
		html += '</div>';
		$parent.append(html);
		const $wind = $parent.find('.windowForm');
		const subwindPos = displayAtt.subwindPos;
		let width = 500;
		let height = 500;
		if (subwindPos != null) {
			width = subwindPos.width;
			height = subwindPos.height;
		}
		$wind.dialog({
			width: width,
			height: height,
			close: this.handleSaveWindowsSettings.bind(this),
			open: this.handleSaveWindowsSettings.bind(this),
			dragStop: this.handleSaveWindowsSettings.bind(this),
			resizeStop: this.handleSaveWindowsSettings.bind(this)
		});

		if (subwindPos != null)
		{
			const $dialparent = $wind.parent();
			$dialparent.css('left', subwindPos.left);
			$dialparent.css('top', subwindPos.top);
		}

		const relDataClass = manager.ds.getDataClassByCollectionName(displayAtt.att.type);
		displayAtt.$subgridWind = $wind;
		const $gridholder = $wind.find('.dataGrid');
		const $gridfooterholder = $wind.find('.rawDisplayFooter');
		const grid = new GridManager(manager.ds, relDataClass, $gridholder, null, $gridfooterholder, null, manager.errorManager);
		const value = manager.curEntity == null ? null : manager.curEntity[attName];
		grid.buildGrid(value).then(() => {
			displayAtt.subgridWind = grid;
		});
	}

	handleRelatedManyClick(event) {
		const $target = $(event.currentTarget);
		const manager = this;
		const attName = betterDecodeURIComponent($target.parent()[0].getAttribute('data-attribute'));
		if (attName != null) {
			const subpath = manager.path + '.' + attName;
			if (event.ctrlKey || event.metaKey) {
				const displayAtt = manager.displayedAttsByName[attName];
				if (displayAtt != null) {
					if (displayAtt.subgridWind == null && displayAtt.$subgridWind == null) {
						const $parent = $target.parent();
						this.createSubGridDialog($parent, displayAtt, subpath);
						/*
						let html;
						html = `<div class="windowForm level${manager.level % 5 + 1}" title="${subpath}" style="width:500px;height:500px;">`;
						html += '  <div class="windowFormContent dataGrid"></div>'
						html += '  <div class="rawDisplayFooter">';
						html += '    <span class="rawDisplayFooterLabel">result: </span>';
						html += '    <span class="rawDisplayFooterValue"></span>';
						html += '    <span class="rawDisplayFooterLabel">/</span>';
						html += '    <span class="rawDisplayFooterValue2"></span>';
						html += '  </div>';
						html += '</div>';
						$parent.append(html);
						const $wind = $parent.find('.windowForm');
						$wind.dialog({ width: 500, height: 500 });
						//$wind.parent().addClass('windowContainer');
						const relDataClass = manager.ds.getDataClassByCollectionName(displayAtt.att.type);
						displayAtt.$subgridWind = $wind;
						const $gridholder = $wind.find('.dataGrid');
						const $gridfooterholder = $wind.find('.rawDisplayFooter');
						displayAtt.subgridWind = new GridManager(manager.ds, relDataClass, $gridholder, null, $gridfooterholder, null, manager.errorManager);
						const value = manager.curEntity[attName];
						displayAtt.subgridWind.buildGrid(value).then(() => {
						});
						*/
					}
					else {
						displayAtt.$subgridWind.dialog('open');
					}
				}
			} else {
				let hidden;
				const $subform = $target.siblings('.subGridHolder');
				if ($subform.hasClass('hidden')) {
					$subform.removeClass('hidden');
					hidden = false;
					$target.find('.formElemFormLabelText').addClass('expanded');
					const displayAtt = manager.displayedAttsByName[attName];
					if (displayAtt != null) {
						if (displayAtt.subgrid == null) {
							const relDataClass = manager.ds.getDataClassByCollectionName(displayAtt.att.type);
							const $gridholder = $target.parent().find('.formElemGrid');
							const $gridfooterholder = $target.parent().find('.rawDisplayFooter');
							displayAtt.subgrid = new GridManager(manager.ds, relDataClass, $gridholder, null, $gridfooterholder, null, manager.errorManager);
							const value = manager.curEntity[attName];
							displayAtt.subgrid.buildGrid(value).then(() => { 

							});
							
						}
					}
				} else {
					$subform.addClass('hidden');
					hidden = true;
					$target.find('.formElemFormLabelText').removeClass('expanded');
				}
				const attSettings = this.getAttSettings(attName, true);
				attSettings.hidden = hidden;
				const displayAtt = manager.displayedAttsByName[attName];
				displayAtt.expanded = !hidden;
				//this.saveSettings();
			}
			event.stopPropagation();
		}
		manager.saveSettings();
	}

	handleRelatedOneClick(event) {
		const $target = $(event.currentTarget).parent();
		const manager = this;
		const attName = betterDecodeURIComponent($target.parent()[0].getAttribute('data-attribute'));
		if (attName != null) {
			const subpath = manager.path + '.' + attName;
			if (event.ctrlKey || event.metaKey) {
				const displayAtt = manager.displayedAttsByName[attName];
				if (displayAtt != null) {
					if (displayAtt.subformWind == null) {
						const $parent = $target.parent();
						this.createSubFormDialog($parent, displayAtt, subpath);
					}
					else {
						displayAtt.$subformWind.dialog('open');
					}
				}
			} else {
				let hidden;
				const $subform = $target.siblings('.subFormHolder');
				if ($subform.hasClass('hidden')) {
					$subform.removeClass('hidden');
					hidden = false;
					$target.find('.formElemFormLabelText').addClass('expanded');
					$target.find('.buttonRelatedForm').removeClass('collapsed');
					const displayAtt = manager.displayedAttsByName[attName];
					if (displayAtt != null) {
						if (displayAtt.subform == null) {
							const relDataClass = manager.ds.getDataClass(displayAtt.att.type);
							displayAtt.subform = new FormManager(relDataClass, null, 0, { $formContent: displayAtt.$subformHolder }, subpath, manager.level + 1, null, null, manager.errorManager);
							if (manager.curEntity != null) {
								const value = manager.curEntity[attName];
								if (value != null) {
									value.fetch().then(subentity => {
										displayAtt.subform.fillForm(subentity);
									}).catch(err => {
										displayAtt.subform.fillForm(null);
										if (manager.errorManager != null) {
											manager.errorManager.display(`Could not get ${manager.path + '.' + attName}`, err.message);
										}
									});
								}
							}
						}
					}
				} else {
					$subform.addClass('hidden');
					hidden = true;
					$target.find('.formElemFormLabelText').removeClass('expanded');
					$target.find('.buttonRelatedForm').addClass('collapsed');
				}
				const attSettings = this.getAttSettings(attName, true);
				attSettings.hidden = hidden;
				const displayAtt = manager.displayedAttsByName[attName];
				displayAtt.expanded = !hidden;
				// this.saveSettings();
			}
			event.stopPropagation();
		}
		manager.saveSettings();
	}
	

	handleResizedElem(event) {
		const $target = $(event.currentTarget);
		const width = $target.width();
		const height = $target.height();
		const attName = betterDecodeURIComponent(event.currentTarget.parentElement.getAttribute('data-attribute'));
		if (attName != null) {
			const attSettings = this.getAttSettings(attName, true);
			const displayAtt = this.displayedAttsByName[attName];
			displayAtt.width = width;
			attSettings.width = width;
			if ($target.hasClass('formElemImageHolder') || $target.hasClass('formElemObjectHolder') || displayAtt.format === 'text') {
				attSettings.height = height;
				displayAtt.height = height;
			}

			this.saveSettings();
		}
	}

	buildForm(attributes) {
		const strrand = 'move' + Math.floor(Math.random() * 100000) + '-' + Math.floor(Math.random() * 100000);
		this.strrand = strrand;
		if (this.$formTitle != null)
			this.$formTitle.html(this.dataclass.getName());
		const $formContent = this.$formContent;
		const manager = this;
		manager.isBuilding = true;
		let html = '';

		let curdivpos = 0;
		
		attributes.forEach((displayAtt) => {
			
			manager.displayedAttsByName[displayAtt.att.name] = displayAtt;

			let labelclass = 'formElemLabel handleToDrag';
			if (displayAtt.inputFormat === 'image' || displayAtt.inputFormat === 'object')
				labelclass = 'formElemImageLabel handleToDrag';
			else if (displayAtt.inputFormat === 'form')
				labelclass += ' formElemFormLabel xform';
			else if (displayAtt.inputFormat === 'grid')
				labelclass += ' formElemFormLabel xgrid';

			const squareselected = displayAtt.squarePict ? 'shapeButtonSelected' : '';
			const roundselected = displayAtt.squarePict ? '' : 'shapeButtonSelected';

			let otherclass = '';
			if (displayAtt.inputFormat === 'form')
				otherclass = 'withSubForm';
			else if (displayAtt.inputFormat === 'grid')
				otherclass = 'withSubGrid';
			
			html += `<div class="attributeToBeMoved receiver ${strrand} formElem ${otherclass}" data-attribute="${encodeURIComponent(displayAtt.att.name)}">`;
			if (displayAtt.inputFormat === 'image') {
				html += `<div class="${labelclass}"><div class="formElemImageLabelText">${displayAtt.label}</div><button class="squareButton ${squareselected}" data-attribute="${encodeURIComponent(displayAtt.att.name)}"></button><button class="roundButton ${roundselected}" data-attribute="${encodeURIComponent(displayAtt.att.name)}"></button></div>`;
			} else if (displayAtt.inputFormat === 'form') {
				html += `<div class="${labelclass}">`;
				html += `<div class="formElemFormLabelText">${displayAtt.label}</div>`;
				/*
				html += `<button class="buttonRelatedForm collapsed"><img class="imageRelatedForm" src="resources/prepare-query.svg">`;
				html += `<button class="buttonRelatedForm collapsed"><img class="imageRelatedForm" src="resources/Query-related.svg">`;
				*/
				html += '</div>';
			} else if (displayAtt.inputFormat === 'grid') {
				html += `<div class="${labelclass}">`;
				html += `<div class="formElemFormLabelText">${displayAtt.label}</div>`;
				html += '</div>';
			} else
				html += `<div class="${labelclass}">${displayAtt.label}</div>`;

			if (displayAtt.inputFormat === 'text') {
				if (displayAtt.format === 'number') {
					html += `<div class="formElemInputHolder number" style="width:${displayAtt.width}px;">`;
					html += '<input pattern="([ ,+e.0-9\\-]*)|null" class="formElemInput" autocomplete="nope" autocorrect="off"/>';
					html += '</div>';
				} else if (displayAtt.format === 'integer') {
					html += `<div class="formElemInputHolder integer" style="width:${displayAtt.width}px;">`;
					html += '<input pattern="([ 0-9\\-]*)|null" class="formElemInput" autocomplete="nope" autocorrect="off"/>';
					html += '</div>';
				} else if (displayAtt.format === 'date') {
					html += `<div class="formElemInputHolder date" style="width:${displayAtt.width}px;">`;
					html += '<input type="date" class="formElemInput" autocomplete="nope" autocorrect="off"/>';
					html += '</div>';
				} else if (displayAtt.format === 'duration') {
					html += `<div class="formElemInputHolder time" style="width:${displayAtt.width}px;">`;
					html += '<input type="text" pattern="(([0-9]*):([0-5]?[0-9]+):([0-5]?[0-9]+))|null" class="formElemInput" autocomplete="nope" autocorrect="off"/>';
					html += '</div>';
				} else {
					let heightStyle = '';
					if (displayAtt.height != null && displayAtt.height != 0) {
						heightStyle = `height:${displayAtt.height}px;`;
					}
					html += `<div class="formElemInputHolder text" style="width:${displayAtt.width}px;${heightStyle}">`;
					html += '<textarea class="formElemInput" autocomplete="nope" autocorrect="off"/>';
					html += '</div>';
				}
			} else if (displayAtt.inputFormat === 'image') {
				const inputid = ("fileInputId" + Math.random()) + Math.random();
				html += `<div class="formElemImageHolder" style="height:${displayAtt.height}px;width:${displayAtt.width}px;">`;
				html += `<input type="file" accept="image/*" id="${inputid}" class="formElemFileInput"/>`;
				html += `<label for="${inputid}" class="formElemFileInputLabel">`;
				if (displayAtt.squarePict)
					html += '<img class="formElemImage square"/>';
				else
					html += '<img class="formElemImage rounded"/>';
				html += '</label>';
				html += '</div>';
			} else if (displayAtt.inputFormat === 'object') {
				html += `<div class="formElemObjectHolder" style="height:${displayAtt.height}px;width:${displayAtt.width}px;">`;
				html += '<pre class="formElemObject "></pre>';
				html += '</div>';
			} else if (displayAtt.inputFormat === 'checkbox') {
				html += '<input type="checkbox" class="formElemCheckBox" autocomplete="nope" autocorrect="off"/>';
			} else if (displayAtt.inputFormat === 'blob') {
				html += `<div class="formElemInputHolder" style="width:${displayAtt.width}px;">`;
				html += '<input class="formElemInput blobCell" autocomplete="nope" autocorrect="off"/>';
				html += '</div>';
			} else if (displayAtt.inputFormat === 'form') {
				html += `<div class="formElemFormHolder subFormHolder" style="height:${displayAtt.height}px">`;
				html += `  <div class="formElemForm subFormContent ${'level' + (manager.level % 5 + 1)}"></div>`;
				html += '</div>';
				displayAtt.subform = null;
				displayAtt.subformWind = null;
			} else if (displayAtt.inputFormat === 'grid') {
				html += `<div class="formElemGridHolder subGridHolder" style="height:${displayAtt.height}px">`;
				html += `  <div class="formElemGrid dataGrid subGridContent ${'level'+(manager.level%5+1)}"></div>`;
				html += '  <div class="rawDisplayFooter">';
				html += '    <span class="rawDisplayFooterLabel">result: </span>';
				html += '    <span class="rawDisplayFooterValue"></span>';
				html += '    <span class="rawDisplayFooterLabel">/</span>';
				html += '    <span class="rawDisplayFooterValue2"></span>';
				html += '  </div>';
				html += '</div>';
				displayAtt.subgrid = null;
				displayAtt.subgridWind = null;
			}
			html += '</div>';
			if (displayAtt.nextline) {
				const curcolpos = curdivpos % 3;
				for (let i = curcolpos + 1; i < 3; ++i) {
					html += '<div class="emptyElem receiver"></div>';
					curdivpos++;
				}
			}
			curdivpos++;
		});
		$formContent.html(html);

		// HtmlDurationPicker.refresh();

		$formContent.on('click', '.squareButton', this.handleShapeButtonClick.bind(this));
		$formContent.on('click', '.roundButton', this.handleShapeButtonClick.bind(this));

		//$formContent.on('click', '.formElemFormLabel.xform', this.handleRelatedOneClick.bind(this));
		$formContent.on('click', '.formElemFormLabelText', this.handleRelatedOneClick.bind(this));
		//$formContent.on('click', '.formElemFormLabel.xgrid', this.handleRelatedManyClick.bind(this));
		$formContent.find('.formElemFormLabel.xgrid').on('click', this.handleRelatedManyClick.bind(this));

		attributes.forEach((displayAtt) => {
			const att = displayAtt.att;
			const $elem = $formContent.find(`div[data-attribute="${encodeURIComponent(att.name)}"`);
			if (displayAtt.inputFormat === 'text') {
				if (displayAtt.format !== 'text') {
					$elem.find('.formElemInputHolder').resizable({ /* autoHide: true, */ handles: 'e' });
					$elem.find('.formElemInputHolder').on('resizestop', this.handleResizedElem.bind(this));
				} else {
					$elem.find('.formElemInputHolder').resizable({ /* autoHide: true, */ handles: 'e, s, se' });
					$elem.find('.formElemInputHolder').on('resizestop', this.handleResizedElem.bind(this));
				}
			} else if (displayAtt.inputFormat === 'image') {
				$elem.find('.formElemImageHolder').resizable({ /* autoHide: true, */ handles: 'e, s, se', aspectRatio: 1 });
				$elem.find('.formElemImageHolder').on('resizestop', this.handleResizedElem.bind(this));
			} else if (displayAtt.inputFormat === 'object') {
				$elem.find('.formElemObjectHolder').resizable({ /* autoHide: true, */ handles: 'e, s, se' });
				$elem.find('.formElemObjectHolder').on('resizestop', this.handleResizedElem.bind(this));
			}  else if (displayAtt.inputFormat === 'form') {
				$elem.find('.formElemFormHolder').resizable({ /* autoHide: true, */ handles: 's' });
				$elem.find('.formElemFormHolder').on('resizestop', this.handleResizedElem.bind(this));
				$elem.find('.formElemFormHolder').addClass('hidden');
				displayAtt.$subformHolder = $elem.find('.subFormContent');
				if (displayAtt.subwindPos != null) {
					this.createSubFormDialog($elem, displayAtt, manager.path+'.'+att.name);
				}
			} else if (displayAtt.inputFormat === 'grid') {
				$elem.find('.formElemGridHolder').resizable({ /* autoHide: true, */ handles: 's' });
				$elem.find('.formElemGridHolder').on('resizestop', this.handleResizedElem.bind(this));
				$elem.find('.formElemGridHolder').addClass('hidden');
				displayAtt.$subGridHolder = $elem.find('.subGridContent');
				if (displayAtt.subwindPos != null) {
					this.createSubGridDialog($elem, displayAtt, manager.path+'.'+att.name);
				}
			}
		});

		$formContent.find('.receiver').droppable({
			accept: `.attributeToBeMoved.${strrand}`,
			drop: manager.handleDropAttribute.bind(this),
			tolerance: 'pointer',
			classes: {
				"ui-droppable-hover" : "hiliteDrop"
			}
		});

		$formContent.find('.attributeToBeMoved').draggable({
			start: (() => {
				$formContent.addClass('dragging');
				$formContent.parent().addClass('draggingInside');
				const x = 1;
			}),
			stop: (() => {
				$formContent.removeClass('dragging');
				$formContent.parent().removeClass('draggingInside');
			}),
			scroll: true,
			/* cursorAt: { right: 5 }, */
			//containment: $formContent,
			// helper: "clone",
			revertDuration: 0,
			revert: true,
			handle: '.handleToDrag'
		});

		/*
		$formContent.find('.formElemInput.durationPicker').durationPicker();
		$formContent.find('.durationpicker-container').addClass("formElemInput");
		*/
		$formContent.find('.formElemInput').on('change', manager.handleChangedInputElem.bind(manager));
		$formContent.find('.formElemInput').on('focus', manager.handleChangedInputElem.bind(manager));
		$formContent.find('.formElemInput').on('blur', manager.handleChangedInputElem.bind(manager));
	
		$formContent.find('.formElemFileInput').on('change', manager.handleChangedInputElem.bind(manager));
		$formContent.find('.formElemFileInput').on('focus', manager.handleChangedInputElem.bind(manager));
		$formContent.find('.formElemFileInput').on('blur', manager.handleChangedInputElem.bind(manager));

		$formContent.find('.formElemCheckBox').on('change', manager.handleChangedCheckElem.bind(manager));

		$formContent.find('.formElemObject').on('change', manager.handleChangedObjElem.bind(manager));
		$formContent.find('.formElemObject').on('focus', manager.handleChangedObjElem.bind(manager));
		$formContent.find('.formElemObject').on('blur', manager.handleChangedObjElem.bind(manager));

		$formContent.find('.formElemImage').on('drop', manager.handleDropImageFile.bind(manager));
		
		$formContent.find('.formElemImage').on('dragenter', manager.handleDragImage.bind(manager));
		$formContent.find('.formElemImage').on('dragover', manager.handleDragImage.bind(manager));
		$formContent.find('.formElemImage').on('dragleave', manager.handleDragImage.bind(manager));
		
		manager.isBuilding = false;
	}

	handleChangedObjElem(event, ui) {
		const elem = event.target.parentElement.parentElement;
		const attName = elem.getAttribute('data-attribute');
		if (attName != null && this.curEntity != null) {
			const displayAtt = this.displayedAttsByName[attName];
			if (displayAtt != null) {
				if (event.type === 'focus') {
					displayAtt.savedObjText = event.target.textContent;
				} else {
					const newText = event.target.textContent;
					if (newText !== displayAtt.savedObjText) {
						try {
							const val = displayAtt.jsonEditor.get();
							$(event.target.parentElement).addClass("touched");
							$(event.target.parentElement).removeClass("invalid");
							this.curEntity[attName] = val;
							this.grid.updateEntity(this.curEntity);
						}
						catch (err) {
							$(event.target.parentElement).removeClass("touched");
							$(event.target.parentElement).addClass("invalid");
						}
					}
				}
			}

		}
	}

	previewFile(file, $img) {
		let reader = new FileReader();
	
		reader.onloadend = function () {
			$img.prop('src', reader.result);
		}
	
		let result = ''
		if (file) {
			reader.readAsDataURL(file);
		} else {
			$img.prop('src', '');
		}
	}

	handleDropImageFile(ev) {
		ev.preventDefault();
		ev.stopPropagation();
		let file = null;
		const items = ev.originalEvent.dataTransfer.items;
		if (items != null && items.length > 0) {
			const item = items[0]
			if (item.kind === "file") {
				file = item.getAsFile();
			}
		} else {
			const files = ev.originalEvent.dataTransfer.files;
			if (files != null && files.length > 0) {
				file = files[0];
			}
		}
		if (file != null) {
			const elem = ev.target.parentElement.parentElement.parentElement;
			const attName = elem.getAttribute('data-attribute');
			if (attName != null && this.curEntity != null) {
				const displayAtt = this.displayedAttsByName[attName];
				const readOnly = displayAtt.readOnly || false;
				if (this.allowEdit && !readOnly) {
					//$(event.target).addClass("touched");
					this.curEntity[attName] = file;
					this.grid.updateEntity(this.curEntity);
					displayAtt.$input.addClass("touched");
					displayAtt.$img.css('opacity', 1);
					this.previewFile(file, displayAtt.$img);
				}
			}
		}
	}

	handleDragImage(event) {
		event.preventDefault();
		event.stopPropagation();
		//console.log(event);
	}

	handleChangedInputElem(event, ui) {
		const elem = event.target.parentElement.parentElement;
		const attName = elem.getAttribute('data-attribute');

		if (attName != null && this.curEntity != null) {
			const val = event.target.value;
			let value = undefined;
			const displayAtt = this.displayedAttsByName[attName];
			switch (event.type) {
				case 'change':
					if (displayAtt != null) {
						switch (displayAtt.format) {
							case 'text':
								value = val;
								break;
							
							case 'number':
								value = parseFloat(val);
								if (Number.isNaN(value))
									value = null;
								break;
							
							case 'integer':
								value = parseInt(val);
								break;
							
							case 'date':
								value = Utils.convertAs('date', val);
								break;
							
							case 'time':
							case 'duration':
								if (val != null && val !== '')
									value = Utils.stringToDuration(val+":00");
								break;
							
							case 'image':
								const files = event.target.files;
								if (files.length > 0) {
									const file = files[0];
									value = file;
									displayAtt.$img.css('opacity', 1);
									this.previewFile(file, displayAtt.$img);
								}
								break;
							
							default:
								break;
						}
					}
					if (value !== undefined) {
						$(event.target).addClass("touched");
						this.curEntity[attName] = value;
						this.grid.updateEntity(this.curEntity);
					}

					break;
				
				case 'focus':
					if (displayAtt != null) {
						if (displayAtt.$input != null) {
							displayAtt.$input.removeClass('nullCell');
						}
						const val = this.curEntity[attName];
						switch (displayAtt.format) {
							case 'text':
								if (val == null)
									displayAtt.$input.val('');
								break;
							case 'number':
							case 'integer':
								if (val == null)
									displayAtt.$input.val('');
								else
									displayAtt.$input.val(String(val));
								break;
							
							default:
								break;
						}
					}
					break;
				
				case 'blur':
					if (displayAtt != null) {
						const val = this.curEntity[attName];
						let value;
						if (val == null) {
							if (displayAtt.$input != null) {
								displayAtt.$input.addClass('nullCell');
								if (displayAtt.format != 'image') {
									if (this.curEntity.isNew())
										displayAtt.$input.val('');
									else
										displayAtt.$input.val('null');
								}
							}
						} else {
							switch (displayAtt.format) {
								case 'number':
									value = Utils.formatNumber(event.target.value, '###,###,###,###,###.####################');
									displayAtt.$input.val(value);
									break;
						
								case 'integer':
									value = Utils.formatNumber(event.target.value, { format: '###,###,###,###,##0', overrideGroup: true });
									displayAtt.$input.val(value);
									break;
						
								default:
									break;
							}
						}
					}
					break;
				
				default:
					break;
			}
		}
	}

	handleChangedCheckElem(event, ui) {
		const elem = event.target.parentElement;
		const attName = elem.getAttribute('data-attribute');
		if (attName != null && this.curEntity != null) {
			this.curEntity[attName] = event.target.checked;
			this.grid.updateEntity(this.curEntity);
		}
	}

	findFormElem(elems, attName) {
		if (attName == null)
			return -1;
		else
			return elems.findIndex(elem => betterDecodeURIComponent(elem.getAttribute('data-attribute')) === attName);
	}

	findFormAnyElem(elems, anyelem) {
		return elems.findIndex(elem => elem === anyelem);
	}

	nextElem(elems, pos) {
		// const line = Math.floor(pos / 3);
		const col = pos % 3;
		if (col == 2) {
			return null;
		} else {
			const elem = elems[pos + 1];
			if (betterDecodeURIComponent(elem.getAttribute('data-attribute')) == null) {
				return null;
			} else {
				return elem;
			}
		}
	}


	handleDropAttribute(event, ui) {

		function newEmptyFormElem() {
			const result = $('<div class="emptyElem receiver newreceiver"></div>');
			return result[0];
		}

		const formContent = this.$formContent;
		const targetAttName = betterDecodeURIComponent(event.target.getAttribute('data-attribute'));
		const sourceAttName = betterDecodeURIComponent(ui.draggable[0].getAttribute('data-attribute'));
		const elems = $.makeArray(formContent.children());
		
		const posTarget = this.findFormElem(elems, targetAttName);
		const posSource = this.findFormElem(elems, sourceAttName);
		const posTargetAnyway = this.findFormAnyElem(elems, event.target);

		if (posSource === -1) {
			const badbad = 1;
		} else {
			const elemSource = elems[posSource];

			const sourceLine = Math.floor(posSource / 3);
			const sourceCol = posSource % 3;
			const nextelem = this.nextElem(elems, posSource);
			if (nextelem == null) {
				if (sourceCol === 0) {
					// if alone on row, remove whole row
					elems.splice(posSource, 3);
				} else {
					// else replace it with empty elem
					elems.splice(posSource, 1);
					elems.splice(posSource, 0, newEmptyFormElem());
				}
			}

			if (posTarget === -1) {
				// insert in an empty space
				if (posTargetAnyway !== -1) {
					elems.splice(posTargetAnyway, 1);
					elems.splice(posTargetAnyway, 0, elemSource);
				}
			} else {
				const posStartLine = Math.floor(posTarget / 3) * 3;
				elems.splice(posStartLine, 0, elemSource, newEmptyFormElem(), newEmptyFormElem());
			}

			formContent.append(elems);

			while ($(formContent.children()[0]).hasClass('emptyElem')) {
				formContent.children()[0].remove();
			}

			const newelems = formContent.find('.newreceiver');
			newelems.droppable({
				accept: `.attributeToBeMoved.${this.strrand}`,
				drop: this.handleDropAttribute.bind(this),
				tolerance: 'pointer',
				classes: {
					"ui-droppable-hover" : "hiliteDrop"
				}
			});
			newelems.removeClass('newreceiver');

			this.reorderAttributes();
			this.saveSettings();
		}


	}

	reorderAttributes() {
		const manager = this;
		const attsByName = this.displayedAttsByName;
		const elems = $.makeArray(this.$formContent.children());
		let pos = 0;
		let attpos = 0;
		const attOrder = [];
		elems.forEach((elem) => {
			const attname = betterDecodeURIComponent(elem.getAttribute('data-attribute'));
			if (attname != null) {
				const displayAtt = attsByName[attname];
				attpos++;
				attOrder.push(attname);
				if (displayAtt != null) {
					const next = manager.nextElem(elems, pos);
					displayAtt.nextline = (next == null);
				}
			}

			pos++;
		});
		this.attOrder = attOrder;

		const newatts = [];
		// const attributes = this.attributes;
		attOrder.forEach((attname) => {
			newatts.push(attsByName[attname]);
		});
		this.attributes = newatts;
	}

	handleDropAttributeOnRow(event, ui) {
		$(event.target).append(ui.draggable);
		const x = 1;
	}

	updateAllowEditStatus() {
		this.setFormEnable(this.allowEdit);
	}


	fillForm(entity) {
		const allowedit = this.allowEdit;
		this.curEntity = entity;
		const manager = this;
		const $formContent = this.$formContent;
		
		this.attributes.forEach((displayAtt) => {
			const att = displayAtt.att;
			let value = null;
			let istouched = false;
			if (entity != null) {
				value = entity[att.name];
				istouched = entity.touchedAtt(att.name);
			}
			const $elem = $formContent.find(`div[data-attribute="${encodeURIComponent(att.name)}"`);
			switch (displayAtt.inputFormat) {
				case 'text':
				case 'blob':
					{
						const $input = $elem.find('.formElemInput');
						displayAtt.$input = $input;
						if (!allowedit)
							$input.prop('disabled', true);
						if (istouched)
							$input.addClass("touched");
						else
							$input.removeClass("touched");
						if (value == null) {
							if (displayAtt.format === 'duration' || displayAtt.format === 'date')
								$input.val('');
							else if (entity != null && entity.isNew())
								$input.val('');
							else
								$input.val('null');
							$input.addClass('nullCell');
						} else {
							$input.removeClass('nullCell');
							switch (displayAtt.format) {
								case 'text':
								default:
									$input.val(value);
									break;

								case 'number':
									value = Utils.formatNumber(value, '###,###,###,###,###.####################');
									$input.val(value);
									break;

								case 'integer':
									value = Utils.formatNumber(value, { format:'###,###,###,###,##0', overrideGroup: true });
									$input.val(value);
									break;

								case 'date':
									//value = Utils.formatDate(value, 'L');
									value = Utils.formatDate(value, 'yy-mm-dd');
									$input.val(value);
									break;

								case 'duration':
									value = Utils.formatDuration(value);
									$input.val(value);
									break;

								case 'blob':
									$input.val('binary content');
									break;
							}
						}
					}
					break;

				case 'checkbox':
					{
						const $input = $elem.find('.formElemCheckBox');
						displayAtt.$input = $input;
						$input.prop('checked', value === true);
						if (!allowedit)
							$input.prop('disabled', true);
					}
					break;

				case 'image':
					{
						const imgobj = value;
						value = null;
						if (imgobj != null && typeof (imgobj) === 'object') {
							const deferred = imgobj.__deferred;
							if (deferred != null) {
								const uri = deferred.uri;
								if (uri != null) {
									value = uri;
								}
							}
						}

						if (value == null) {
							$elem.find('.formElemImage').prop('src', '');
							$elem.find('.formElemImage').css('opacity', 0);
						} else {
							$elem.find('.formElemImage').prop('src', value);
							$elem.find('.formElemImage').css('opacity', 1);
						}
						const $input = $elem.find('.formElemFileInput');
						// displayAtt.$input = $elem.find('.formElemImage');
						displayAtt.$input = $input;
						displayAtt.$img =  $elem.find('img');
						if (!allowedit)
							$input.prop('disabled', true);
						else
							displayAtt.$img.addClass("selectable");
						if (istouched)
							$input.addClass("touched");
						else
							$input.removeClass("touched");
					}
					break;

				case 'object':
					{
						const $input = $elem.find('.formElemObject');
						displayAtt.$input = $input;
						/*
						if (value == null)
							value = {};
							*/
						const readOnly = displayAtt.readOnly || false;
						if (displayAtt.jsonEditor == null) {
							displayAtt.jsonEditor = new JsonEditor($input, value, { editable: allowedit && !readOnly });
						} else {
							displayAtt.jsonEditor.load(value);
						}
						$input.parent().removeClass("invalid");
						if (istouched)
							$input.parent().addClass("touched");
						else
							$input.parent().removeClass("touched");
					}
					break;
				
				case 'form':
					{
						if (displayAtt.subform != null) {
							if (value == null) {
								displayAtt.subform.fillForm(null);
							} else {
								value.fetch().then(subentity => {
									displayAtt.subform.fillForm(subentity);
								}).catch(err => {
									displayAtt.subform.fillForm(null);
									if (manager.errorManager != null) {
										manager.errorManager.display(`Could not get ${manager.path + '.' + displayAtt.att.getName()}`, err.message);
									}
								});
							}
						}
						if (displayAtt.subformWind != null) {
							if (value == null) {
								displayAtt.subformWind.fillForm(null);
							} else {
								value.fetch().then(subentity => {
									displayAtt.subformWind.fillForm(subentity);
								}).catch(err => {
									displayAtt.subformWind.fillForm(null);
									if (manager.errorManager != null) {
										manager.errorManager.display(`Could not get ${manager.path+'.'+displayAtt.att.name}`, err.message);
									}
										
								});
							}
						}
					}
					break;

				case 'grid':
					{
						if (displayAtt.subgrid != null) {
							displayAtt.subgrid.setCurrentSelection(value);
						}
						if (displayAtt.subgridWind != null) {
							displayAtt.subgridWind.setCurrentSelection(value);
						}
					}
					break;
	
				default:
					break;
			}

		});
		// HtmlDurationPicker.refresh();
		this.setFormEnable(allowedit);
	}

	setFormEnable(enable) {
		const $formContent = this.$formContent;
		if (enable)
			$formContent.find('.buttonRelatedForm').removeClass('hidden');
		else
			$formContent.find('.buttonRelatedForm').addClass('hidden');
		this.attributes.forEach((displayAtt) => {
			const $input = displayAtt.$input;
			if ($input != null) {
				
				const att = displayAtt.att;
				switch (displayAtt.inputFormat) {
					case 'text':
					case 'blob':
					case 'checkbox':
					case 'image':
						{
							const readonly = displayAtt.inputFormat == 'blob' || att.readOnly || false;
							$input.prop('disabled', !enable || readonly);
							if (displayAtt.$img != null) {
								if (!enable || readonly)
									displayAtt.$img.removeClass("selectable");
								else
								displayAtt.$img.addClass("selectable");
							}
						}
						break;
					
					case 'object':
						{
							const readOnly = displayAtt.readOnly || false;
							if (!readOnly) {
								const waseditable = displayAtt.jsonEditor.options.editable;
								const val = displayAtt.jsonEditor.get();
								if (waseditable != enable) {
									displayAtt.jsonEditor.options.editable = enable;
									displayAtt.jsonEditor.load(val);
								}
							}
						}
						break;
					
					default:
						break;
				}

				if (enable)
					$input.removeClass('nonselectable');
				else
					$input.addClass('nonselectable');
			}
		});

		if (this.$formBar2 != null) {
			if (enable)
				this.$formBar2.find('.formBar2Button').removeClass("hidden");
			else
				this.$formBar2.find('.formBar2Button').addClass("hidden");
		}
	}

	destroy() {
		const manager = this;
		this.attributes.forEach(displayAtt => {
			if (displayAtt.subform != null)
				displayAtt.subform.destroy();
			if (displayAtt.subformWind != null) {
				displayAtt.subformWind.destroy();
				displayAtt.$subformWind.dialog('destroy');
			}
		});
		this.$formContent.html('');
		if (this.$formBar1 != null)
			this.$formBar1.find('.formBar1Button').off();
		if (this.$formBar2 != null)
			this.$formBar2.find('.formBar2Button').off();
	}

	looseFocus() {
		this.attributes.forEach(displayAtt => {
			if (displayAtt.subformWind != null) {
				displayAtt.subformWind.looseFocus();
				displayAtt.$subformWind.dialog('close');
			}
		});
	}

	gainFocus() {
		this.attributes.forEach(displayAtt => {
			if (displayAtt.subformWind != null) {
				displayAtt.subformWind.gainFocus();
				displayAtt.$subformWind.dialog('open');
			}
		});
	}


}

